// Nearest Neighbor -- Region Approach         Bill Rubin         7/16/2010
#include <Instrumentation.h>
#include <SolutionConfiguration.h>
#include <Points.h>
#include <algorithm>
#include <iostream>
#include <ctime>

Instrumentation instrumentation;

inline void setRandom(Point& point) {point = Point();}
                
void main() {
    // Initialize random number generator
    ::srand(static_cast<unsigned int>(::time(0)));

    for(int k = 0; k<100; ++k) {  // Run many random trials
        // Generate random points
        const int numberOfPoints = 1000;
        Points::PointVector inputPoints(numberOfPoints);
        std::for_each(inputPoints.begin(), inputPoints.end(), setRandom);

        // Construct target
        const Point target;

        // Prepare points for target search    
        const Points points(inputPoints);

        // Search for closest point to target
        //const Point* const closest = points.findClosest(target);
        const SolutionConfiguration solutionConfiguration(points.findClosest(target));
        std::cout<<solutionConfiguration<<"  "<<instrumentation<<"\n";
        instrumentation.accumulate(solutionConfiguration);
        }

    std::cout<<"\tAverage:  "<<instrumentation.getAverageNumberOfComparisons()
             <<" point comparisons per target; "
             << instrumentation.getTotalNumberOfFailures()<<" failures.\n";
}