#pragma once
#include <Points.h>

class SolutionConfiguration {
    public:
        typedef Points::RegionIterators RegionIterators;
        SolutionConfiguration(const Point target, const RegionIterators&);
        void search(int ordinal, coord closestAchievableDistance);
        const Point* getClosestPoint() const {return closestPtr_;}
        coord getClosestDistance() const {return closestDistance_;}
        friend std::ostream& operator<<(std::ostream&, const SolutionConfiguration&);

    private:
        // Input
        Point target_;
        const RegionIterators* regionIterators_;

        // Result
        const Point* closestPtr_;  // -> point closest to target, or null if no close point found.
        coord closestDistance_;  // Distance from *closestPtr to target
};