#include <SolutionConfiguration.h>
#include <Region.h>

SolutionConfiguration::SolutionConfiguration(const Point target, 
    const RegionIterators& regionIterators)
    : target_(target),
    regionIterators_(&regionIterators),
    closestPtr_(0),
    closestDistance_(Region::getRadialDistance(target_)) {}

void SolutionConfiguration::search(const int ordinal, 
        const coord closestAchievableDistance) {  // Min distance from Region to target

    const Point* const endPtr = (*regionIterators_)[ordinal + 1];
    for(const Point* pointPtr = (*regionIterators_)[ordinal]; pointPtr!=endPtr; ++pointPtr) {
        const coord dist = distance(target_, *pointPtr);        
        if(dist<closestDistance_) {
            closestDistance_ = dist;
            closestPtr_ = pointPtr;
            if(closestDistance_==closestAchievableDistance) break;
            }                
        }
}

std::ostream& operator<<(std::ostream& os, const SolutionConfiguration& solutionConfiguration) {
    if(solutionConfiguration.closestPtr_==0) os<<"No point is close to";
    else os<<"Point "<<*solutionConfiguration.closestPtr_<<" is "
           <<solutionConfiguration.closestDistance_<<" from";
    os<<" target "<<solutionConfiguration.target_;
    return os;
}