#pragma once
#include <Point.h>
#include <vector>

class Region {
    public:
        explicit Region(Point point)
            : i_(point.getX()/Parameters::getRegionSize()),
              j_(point.getY()/Parameters::getRegionSize()) {}

        int getOrdinal() const {return i_ + Parameters::getNumRegions()*j_;}
        coord getClosestDistance(Point) const;  // Considers all possible points.

        typedef std::vector<Region> RegionVector;
        // Neighboring regions are returned in order of increasing distance
        // from target.  Only regions closer than closestDistance are included.
        // From zero to three regions are returned, depending on geometry.
        RegionVector getNeighboringRegions(Point target, coord closestDistance) const;

        static coord getRadialDistance(Point);

    private:
        Region(int i, int j) : i_(i), j_(j) {}

        int i_;
        int j_;
};