#pragma once
#include <Point.h>
#include <vector>

class SolutionConfiguration;

class Points {
    public:
        typedef std::vector<Point> PointVector;
        typedef std::vector<const Point* const> RegionIterators;
        explicit Points(const PointVector& inputPoints);
        SolutionConfiguration findClosest(Point target) const;

    private:
        class PointReference;
        
        PointVector points_;  // Ordered by region
        RegionIterators regionIterators_;  // -> points_
};
