#pragma once
#include <Parameters.h>
#include <Instrumentation.h>
#include <cmath>
#include <ostream>

typedef short coord;

class Point {
    public:        
        Point() : x_(randomCoord()), y_(randomCoord()) {}
        Point(coord x, coord y) : x_(x), y_(y) {}
        coord getX() const {return x_;}
        coord getY() const {return y_;}

    private:
        static int randomCoord() {return ::rand()%Parameters::getNumCoords();}

        coord x_;
        coord y_;
};

inline coord norm(Point point) {return std::abs(point.getX()) + std::abs(point.getY());}
inline Point operator-(Point p1, Point p2) {return Point(p1.getX() - p2.getX(), p1.getY() - p2.getY());}

inline coord distance(Point p1, Point p2) {
    extern Instrumentation instrumentation;
    instrumentation.countComparison();
    return norm(p1 - p2); 
    }

inline std::ostream& operator<<(std::ostream& os, Point point) {
    os<<"("<<point.getX()<<", "<<point.getY()<<")";
    return os;
}