#pragma once
#include <ostream>

class SolutionConfiguration;

class Instrumentation {
    public:
        Instrumentation() : numberOfComparisons_(0), numberOfTargets_(0), 
            totalNumberOfComparisons_(0), totalNumberOfFailures_(0) {}
        
        unsigned int getNumberOfComparisons() const {return numberOfComparisons_;}
        void countComparison() {++numberOfComparisons_;}
        void accumulate(const SolutionConfiguration&); 

        double getAverageNumberOfComparisons() 
            {return totalNumberOfComparisons_/(double)(numberOfTargets_);}

        unsigned int getTotalNumberOfFailures() const {return totalNumberOfFailures_;}

    private:
        unsigned int numberOfComparisons_;
        unsigned int numberOfTargets_;
        unsigned int totalNumberOfComparisons_;
        unsigned int totalNumberOfFailures_;
};

inline std::ostream& operator<<(std::ostream& os, const Instrumentation& instrumentation) {
    os<<instrumentation.getNumberOfComparisons()<<" point comparisons.";
    return os;
}