// Nearest Neighbor -- Hash Table Approach       Bill Rubin         7/16/2010
#include <SolutionConfiguration.h>
#include <algorithm>
#include <iostream>
#include <ctime>

extern const int numCoords_global = 601;

inline void setRandom(Point& point) {point = Point();}
                
void main() {
    // Initialize random number generator
    ::srand(static_cast<unsigned int>(::time(0)));

    for(int k = 0; k<1; ++k) {  // Run many random trials
        // Generate random points
        const int numberOfPoints = 1000;
        Points::PointVector inputPoints(numberOfPoints);
        std::for_each(inputPoints.begin(), inputPoints.end(), setRandom);

        // Construct target
        const Point target;

        // Prepare points for target search    
        const Points points(inputPoints);

        // Search for closest point to target
        //const Point* const closest = points.findClosest(target);
        const SolutionConfiguration solutionConfiguration(points.findClosest(target));
        std::cout<<solutionConfiguration<<"\n";
        }
}