#pragma once
#include <Points.h>

class SolutionConfiguration {
    public:
        SolutionConfiguration(const Point target);

        void setClosestPoint(const Point point) {
            closestPoint_ = point; 
            closestDistance_ = distance(target_, closestPoint_);
            }
        
        friend std::ostream& operator<<(std::ostream&, const SolutionConfiguration&);

    private:
        // Input
        Point target_;

        // Result
        Point closestPoint_;  // point closest to target
        coord closestDistance_;  // Distance from closestPoint to target
};