#pragma once
#include <cmath>
#include <ostream>

typedef short coord;

class Point {
    public:        
        Point() : x_(randomCoord()), y_(randomCoord()) {}
        Point(const coord x, const coord y) : x_(x), y_(y) {}
        coord getX() const {return x_;}
        coord getY() const {return y_;}

        void incrementNortheast() {++x_; ++y_;}
        void incrementNorthwest() {--x_; ++y_;}
        void incrementSoutheast() {++x_; --y_;}
        void incrementSouthwest() {--x_; --y_;}

        int getKey() const {
            extern const int numCoords_global;
            return x_ +  numCoords_global*y_;
            }

    private:
        static int randomCoord() {
            extern const int numCoords_global; 
            return ::rand()%numCoords_global;
            }

        coord x_;
        coord y_;
};

inline coord norm(Point point) {return std::abs(point.getX()) + std::abs(point.getY());}
inline Point operator-(Point p1, Point p2) {return Point(p1.getX() - p2.getX(), p1.getY() - p2.getY());}
inline coord distance(Point p1, Point p2) {return norm(p1 - p2);}

inline std::ostream& operator<<(std::ostream& os, Point point) {
    os<<"("<<point.getX()<<", "<<point.getY()<<")";
    return os;
}

inline bool isInvalid(const Point point) {
    extern const int numCoords_global;
    return point.getX()<0 || point.getX()>=numCoords_global
        || point.getY()<0 || point.getY()>=numCoords_global;
    }